/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.dialog;

import filenet.vw.toolkit.runtime.images.VWImageLoader;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public final class VWUnlockWorkConfirmDialog
extends VWModalDialog {
    private boolean m_bCanceled = true;
    private boolean m_bYes = false;
    private JPanel m_mainPanel = null;
    private JPanel m_buttonPanel = null;
    private JPanel m_iconPanel = null;
    private JTextArea m_infoTextArea = null;
    private JLabel m_warningIcon = null;
    private JButton m_yesButton = new JButton(VWResource.s_yes);
    private JButton m_noButton = new JButton(VWResource.s_no);
    private JButton m_cancelButton = new JButton(VWResource.s_cancel);
    private ActionListener m_yesButtonActionListener = null;
    private ActionListener m_noButtonActionListener = null;
    private ActionListener m_cancelButtonActionListener = null;

    public VWUnlockWorkConfirmDialog(Frame parent) {
        super(parent);
        this.setupLayout();
    }

    protected void setupLayout() {
        Container contentPane = this.getContentPane();
        this.setResizable(true);
        Dimension dim = VWStringUtils.stringToDimension(VWResource.s_unlockWorkConfirmDialogDim);
        if (dim == null) {
            dim = new Dimension(330, 180);
        }
        this.setSize(dim.width, dim.height);
        this.setVisible(false);
        this.setTitle(VWResource.s_unlockWorkConfirmationDialogTitle);
        this.m_mainPanel = new JPanel();
        this.m_mainPanel.setLayout(new BorderLayout(10, 10));
        this.m_infoTextArea = new JTextArea(VWResource.s_unlockConfirmMessage);
        this.m_infoTextArea.setLineWrap(true);
        this.m_infoTextArea.setWrapStyleWord(true);
        this.m_infoTextArea.setOpaque(false);
        this.m_infoTextArea.setEditable(false);
        this.m_warningIcon = new JLabel(VWImageLoader.createImageIcon("warning.gif"));
        this.m_iconPanel = new JPanel();
        this.m_iconPanel.setLayout(new BoxLayout(this.m_iconPanel, 3));
        this.m_iconPanel.add(this.m_warningIcon);
        this.m_buttonPanel = new JPanel();
        this.m_buttonPanel.setLayout(new FlowLayout());
        this.m_buttonPanel.add(this.m_yesButton);
        this.m_buttonPanel.add(this.m_noButton);
        this.m_buttonPanel.add(this.m_cancelButton);
        this.m_mainPanel.add((Component)this.m_infoTextArea, "Center");
        this.m_mainPanel.add((Component)this.m_iconPanel, "Before");
        this.m_mainPanel.add((Component)this.m_buttonPanel, "Last");
        this.m_mainPanel.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        contentPane.setLayout(new BorderLayout());
        contentPane.add((Component)this.m_mainPanel, "Center");
        this.m_yesButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWUnlockWorkConfirmDialog.this.m_bCanceled = false;
                VWUnlockWorkConfirmDialog.this.m_bYes = true;
                VWUnlockWorkConfirmDialog.this.setVisible(false);
            }
        };
        this.m_yesButton.addActionListener(this.m_yesButtonActionListener);
        this.m_noButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWUnlockWorkConfirmDialog.this.m_bCanceled = false;
                VWUnlockWorkConfirmDialog.this.m_bYes = false;
                VWUnlockWorkConfirmDialog.this.setVisible(false);
            }
        };
        this.m_noButton.addActionListener(this.m_noButtonActionListener);
        this.m_cancelButtonActionListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                VWUnlockWorkConfirmDialog.this.m_bCanceled = true;
                VWUnlockWorkConfirmDialog.this.setVisible(false);
            }
        };
        this.m_cancelButton.addActionListener(this.m_cancelButtonActionListener);
    }

    public void addNotify() {
        super.addNotify();
        Font boldFont = null;
        Font font = null;
        font = this.getFont();
        if (font != null) {
            boldFont = new Font(font.getName(), 1, font.getSize());
        }
        if (boldFont != null) {
            this.m_infoTextArea.setFont(boldFont);
        }
    }

    public boolean isCanceled() {
        return this.m_bCanceled;
    }

    public boolean isYes() {
        return this.m_bYes;
    }

    public void removeReferences() {
        this.m_infoTextArea = null;
        this.m_warningIcon = null;
        if (this.m_yesButton != null) {
            this.m_yesButton.removeActionListener(this.m_yesButtonActionListener);
            this.m_yesButton = null;
        }
        this.m_yesButtonActionListener = null;
        if (this.m_noButton != null) {
            this.m_noButton.removeActionListener(this.m_noButtonActionListener);
            this.m_noButton = null;
        }
        this.m_noButtonActionListener = null;
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this.m_cancelButtonActionListener);
            this.m_cancelButton = null;
        }
        this.m_cancelButtonActionListener = null;
        if (this.m_buttonPanel != null) {
            this.m_buttonPanel.setLayout(null);
            this.m_buttonPanel.removeAll();
            this.m_buttonPanel = null;
        }
        if (this.m_iconPanel != null) {
            this.m_iconPanel.setLayout(null);
            this.m_iconPanel.removeAll();
            this.m_iconPanel = null;
        }
        if (this.m_mainPanel != null) {
            this.m_mainPanel.setLayout(null);
            this.m_mainPanel.removeAll();
            this.m_mainPanel = null;
        }
        this.removeAll();
        super.removeReferences();
    }
}

